/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.PlotDataXY;
import util.Logger;
import view.MainView;

public abstract class FitData {
    static Logger logger = Logger.getLogger();
    protected MainView myView;
    protected final double[] xin;
    protected final double[] yin;
    protected double[] xout;
    protected double[] yout;
    protected double[] xinvert;
    protected double[] yinvert;
    protected int nodesin;
    protected int rangein;
    protected int extra;

    public int getNodesIn() {
        return this.nodesin;
    }

    public double getXin(int i) {
        return this.xin[i];
    }

    public FitData(MainView pView, int pnonodes) {
        this.myView = pView;
        this.extra = 0;
        this.nodesin = pnonodes;
        this.rangein = 360 / this.nodesin;
        this.xin = new double[this.nodesin];
        this.yin = new double[this.nodesin];
    }

    public void addInput(int index, double xval, double yval) {
        if (index >= this.nodesin) {
            logger.log(1, "FitData.add ERROR index out of bounds");
        } else {
            this.xin[index] = xval;
            this.yin[index] = yval;
        }
    }

    protected abstract void fitCorr();

    public PlotDataXY getDataIn() {
        logger.entry(4, "FitData.getDataIn");
        PlotDataXY pd = new PlotDataXY();
        int i = 0;
        while (i < this.nodesin) {
            pd.addPoint(this.xin[i], this.yin[i]);
            ++i;
        }
        logger.exit(4, "FitData.getDataIn");
        return pd;
    }

    public PlotDataXY getDataOut() {
        logger.entry(4, "FitData.getDataOut");
        PlotDataXY pd = new PlotDataXY();
        int i = 0;
        while (i < this.xout.length - 2 * this.extra) {
            pd.addPoint(this.xout[this.extra + i], this.yout[this.extra + i]);
            ++i;
        }
        logger.exit(4, "FitData.getDataOut");
        return pd;
    }

    protected void invert() {
        int i = 0;
        while (i < this.xout.length) {
            this.xinvert[i] = this.yout[i];
            this.yinvert[i] = this.xout[i];
            ++i;
        }
    }

    public PlotDataXY getDataInvert() {
        logger.entry(4, "FitData.getDataInvert");
        PlotDataXY pd = new PlotDataXY();
        int i = 0;
        while (i < this.xinvert.length - 2 * this.extra) {
            pd.addPoint(this.xinvert[this.extra + i], this.yinvert[this.extra + i]);
            ++i;
        }
        logger.entry(4, "FitData.getDataInvert");
        return pd;
    }

    public double getCorrectedVal(double azi) {
        double result = 0.0;
        int n = 1;
        while (n < this.xinvert.length - 1 && this.xinvert[n] < azi) {
            ++n;
        }
        double slope = (this.yinvert[n] - this.yinvert[n - 1]) / (this.xinvert[n] - this.xinvert[n - 1]);
        double x0 = this.xinvert[n - 1];
        double y0 = this.yinvert[n - 1];
        result = slope * (azi - x0) + y0;
        return result;
    }

    public double getRmsOut() {
        logger.entry(4, "FitData.getRmsOut");
        int count = 0;
        double rms = 0.0;
        double delta = 0.0;
        int i = 0;
        while (i < this.yout.length - 2 * this.extra) {
            ++count;
            delta = this.yout[this.extra + i] - this.xout[this.extra + i];
            rms += delta * delta;
            ++i;
        }
        rms = Math.sqrt(rms / (double)count);
        logger.exit(4, "FitData.getRmsOut");
        return rms;
    }

    public void logDataIn() {
        logger.entry(4, "FitData.logDataIn");
        int i = 0;
        while (i < this.xin.length) {
            logger.log(5, "Fitdata in: " + i + " " + this.xin[i] + " " + this.yin[i]);
            ++i;
        }
        logger.exit(4, "FitData.logDataIn");
    }

    public void logDataOut() {
        logger.entry(4, "FitData.logDataOut");
        int i = 0;
        while (i < this.xout.length) {
            logger.log(5, "FitData out: " + i + " " + this.xout[i] + " " + this.yout[i]);
            ++i;
        }
        logger.exit(4, "FitData.logDataOut");
    }

    public PlotDataXY getCorrVals() {
        logger.entry(4, "FitData.getCorrVals");
        PlotDataXY pd = new PlotDataXY();
        int i = 0;
        while (this.xinvert[i] < 0.0) {
            ++i;
        }
        while (this.xinvert[i] < 360.0) {
            double x = this.xinvert[i];
            double y = this.yinvert[i] - this.xinvert[i];
            logger.log(6, "x , y = " + x + ", " + y);
            pd.addPoint(x, y);
            ++i;
        }
        logger.exit(4, "FitData.getCorrVals");
        return pd;
    }

    public double getRmsSimul() {
        logger.entry(4, "FitData.getRmsSimul");
        double rms = 0.0;
        double delta = 0.0;
        int i = 0;
        while (i < this.nodesin) {
            delta = this.getCorrectedVal(this.yin[i]) - this.xin[i];
            rms += delta * delta;
            ++i;
        }
        rms = Math.sqrt(rms / (double)this.nodesin);
        logger.exit(4, "FitData.getRmsSimul");
        return rms;
    }

    public PlotDataXY getSimulVals() {
        logger.entry(4, "FitData.getSimulVals");
        PlotDataXY pd = new PlotDataXY();
        int i = 0;
        while (i < this.nodesin) {
            pd.addPoint(this.xin[i], this.getCorrectedVal(this.yin[i]));
            ++i;
        }
        logger.exit(4, "FitData.getSimulVals");
        return pd;
    }

    public PlotDataXY getYout() {
        logger.entry(4, "FitData.getYout");
        PlotDataXY pd = new PlotDataXY();
        int i = 0;
        while (i < this.yout.length - 2 * this.extra) {
            pd.addPoint(this.xout[this.extra + i], this.yout[this.extra + i]);
            ++i;
        }
        logger.exit(4, "FitData.getYout");
        return pd;
    }
}

